cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\"
set more off

use "Merged Dataset.dta", clear

*drop non-religion and those with missing religious affiliation* 
drop if (noreligion==1 | relminority==. | (noreligion==. & usa==1))

egen missexpertise = rowmiss(polknowledge polinterest polexposure)
egen missrfs = rowmiss(rfs1-rfs12)
egen missia = rowmiss(iasocial iaedu iacrime iatax)

egen expertise = rowmean(polknowledge polinterest polexposure)
replace expertise = . if missexpertise>1
egen rfs = rowmean(rfs1-rfs12)
replace rfs = . if missrfs>6
egen ia = rowmean(iasocial iaedu iacrime iatax)
replace ia = . if missia>2

*standardize independent variables*
egen zexpertise = std(expertise)
egen zrfs = std(rfs)
egen zia = std(ia)
egen zedu = std(edu)
egen zage = std(age)

*set output directory*
cd "C:\Data\Dropbox\Research\2012- Paradoxical Religiosity\Data\Replication Data\Results"


/*==================================================================================*/
/*INTERACTIONS*/
/*==================================================================================*/
gen usaXtrel = usa*trel
gen usaXtblending = usa*tblending
gen usaXtseparate = usa*tseparate

gen trelXzrfs = trel*zrfs
gen tblendingXzrfs = tblending*zrfs
gen tseparateXzrfs = tseparate*zrfs

gen usaXzrfs = usa*zrfs
gen usaXtrelXzrfs = usa*trel*zrfs
gen usaXtblendingXzrfs = usa*tblending*zrfs
gen usaXtseparateXzrfs = usa*tseparate*zrfs


/*==================================================================================*/
/*ANALYSIS */
/*==================================================================================*/
foreach yvar of varlist voting attitude competence integrity {
	reg `yvar' usa relminority zedu zage zexpertise zia trel tblending tseparate zrfs
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using main_religious_only, bdec(2) sdec(2) tdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
	predict e, resid
	histogram e, normal
	graph export `yvar'.png
	drop e

	reg `yvar' usa relminority zedu zage zexpertise zia trel tblending tseparate zrfs usaXtrel usaXtblending usaXtseparate
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using main_religious_only, bdec(2) sdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
	
	reg `yvar' usa relminority zedu zage zexpertise zia trel tblending tseparate zrfs usaXtrel usaXtblending usaXtseparate trelXzrfs tblendingXzrfs tseparateXzrfs
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using main_religious_only, bdec(2) sdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
	
	reg `yvar' usa relminority zedu zage zexpertise zia trel tblending tseparate zrfs usaXtrel usaXtblending usaXtseparate trelXzrfs tblendingXzrfs tseparateXzrfs usaXzrfs usaXtrelXzrfs usaXtblendingXzrfs usaXtseparateXzrfs
	local p =  Ftail(`e(df_m)',`e(df_r)',`e(F)')
	outreg2 using main_religious_only, bdec(2) sdec(2) rdec(2) alpha(.01, .05, .10) addstat("F-Test", e(F), "Prob > F", `p') excel append
}
